procedure contribs
argument local numeric runno
argument local numeric series by case agelower = list(16,25,16,55)
argument local numeric series by case ageupper = list(80,54,24,80)
argument local string scalar db_path = ""
block
   open <ac re> file(local'db_path+"/lfpr_run"+string(runno)+".db") as lout
   open <ac re> file(local'db_path+"/input.db" as lfprin
   open <ac re> file(local'db_path+"/cpscovar_rev.db") as cpsrev

   -local'ex = ""

   local'syear = year(lout'start_est&".m"); -local'eyear = year(lout'end_frcst&".m")

   -- set up time effects

   if exists(lout'temm)
      local't_fm = convert(lout'tefm,m,discrete,ave)
      local't_mm = convert(lout'temm,m,discrete,ave)
   end if


   loop for sex in {m,f}
      loop for age = 16 to 79
         -- set up cohort effects
         block
            freq m
            date lout'start_est&".m" to lout'end_frcst&".m"
            <date *> -local'coeff = log(lout'ce&sex&m)
            -local'c_&sex&age&m = series(0d0)
            if lout'smoothed eq 1
               loop for yy = syear to eyear
                  set <date yy> local'c_&sex&age&m = &&
                     local'coeff[yy-age]*(2.0d0*period(t)-1d0)/24d0 + &&
                     local'coeff[yy-age-1]*(24d0+1d0-2*period(t))/24d0
               end loop
            else 
               loop for yy = syear to eyear
                  set <date yy> local'c_&sex&age&m = local'coeff[yy-age]
               end loop
            end if
         end block

         series <over on> work'vind:string indexed by case
         -work'vcount = 1
         set vind[1] = "0"
         -local'cnvar0 = local'c_&sex&age&m

         if exists(lout'temm)
            set vcount = vcount+1
            set vind[vcount] = "100"
            -local'cnvar100 = local't_&sex&m
         end if

         if exists(lout'vars)
            loop for i=1 to lastvalue(lout'vars)
               -- next if lout'varcyc[i] eq 1
               if exists(lout'id(lout'vars[i])&c&sex&age&m)
                  set vcount = vcount+1
                  set vind[vcount] = string(i)
                  date * to *
                  if lout'vartype[i] eq 0 or lout'vartype[i] eq 2
                     -local'var = lfprin'id(lout'vars[i])&_m
                  else if lout'vartype[i] eq 1 or lout'vartype[i] eq 3
                     -local'var = lfprin'id(lout'vars[i])&_a&age&_m
                  else if lout'vartype[i] eq 4 or lout'vartype[i] eq 6
                     -local'var = lfprin'id(lout'vars[i])&_a&age&sex&_m
                  else if lout'vartype[i] eq 5
                     -local'var = lfprin'id(lout'vars[i])&_&sex&_m
                  end if

                  if lout'varnorm[i] eq 1
                     date lout'start_est&".m" to lout'end_est&".m"
                     which not missing(local'var)
                     -local'ave_v = ave(local'var); -local'stderr_v = stddev(local'var)

                     date * to *
                     -local'nvar = precision((local'var-local'ave_v)/local'stderr_v)
                  else
                     -local'nvar = local'var
                  end if

                  -local'cnvar&i = precision(local'nvar*lout'id(lout'vars[i])&c&sex&age&m)
                  if lout'varlagged[i] eq 1
                     loop for LL = 1 to lastvalue(lout'v&i&_lags)
                        set vcount = vcount+1
                        set vind[vcount] = string(i)+"l"+string(lout'v&i&_lags[LL])
                        -local'cnvar&id(vind[vcount]) = shift(local'nvar,-lout'v&i&_lags[LL])*lout'id(lout'vars[i])&c&id(string(lout'v&i&_lags[LL]))&sex&age&m
                     end loop
                  end if
               end if
            end loop
         end if

         loop for v=1 to vcount
            -- 'dc' series use derivative-based approximation BEFORE weighting by total pop shares
            series <freq m> local'dc_v&id(vind[v])&_a&age&_g&sex:precision indexed by date

            -- 'cc' series use derivative-based approximation AFTER weighting by total pop shares
            series <freq m> local'cc_v&id(vind[v])&_a&age&_g&sex:precision indexed by date
         end loop

         -local'lfprp_a&age&_g&sex = lout'id(lout'lfpname)&id(local'ex)&_pred&sex&age&m
         -- -local'lfprt_a&age&_g&sex = lout'id(lout'lfpname)&id(local'ex)&_mod&sex&age&m
         -- -local'lfpra_a&age&_g&sex = lout'id(lout'lfpname)&id(local'ex)&sex&_a&age

         loop for v=1 to vcount
            -local'dc_v&id(vind[v])&_a&age&_g&sex = mave(local'lfprp_a&age&_g&sex*(1-local'lfprp_a&age&_g&sex),2)*diff(local'cnvar&id(vind[v]))
            -local'cc_v&id(vind[v])&_a&age&_g&sex = mave(cpsrev'ts&sex&_a&age,2)*dc_v&id(vind[v])&_a&age&_g&sex
         end loop

         -local'dcp_pop&sex&_a&age&m = diff(cpsrev'ts&sex&_a&age)*mave(lout'id(lout'lfpname+local'ex+"_pred")&sex&age&m,2)
         -local'dca_pop&sex&_a&age&m = diff(cpsrev'ts&sex&_a&age)*mave(lout'id(lout'lfpname+local'ex)&sex&age&m,2)

         -local'dcp_lfpr&sex&_a&age&m = mave(cpsrev'ts&sex&_a&age,2)*diff(lout'id(lout'lfpname+local'ex+"_pred")&sex&age&m)
         -local'dca_lfpr&sex&_a&age&m = mave(cpsrev'ts&sex&_a&age,2)*diff(lout'id(lout'lfpname+local'ex)&sex&age&m)

      end loop

      -local'dcp_pop&sex&_a80m = diff(cpsrev'ts&sex&_a80)*mave(cpsrev'id(lout'lfpname+local'ex)&sex&_a80,2)
      -local'dca_pop&sex&_a80m = diff(cpsrev'ts&sex&_a80)*mave(cpsrev'id(lout'lfpname+local'ex)&sex&_a80,2)

      -local'dcp_lfpr&sex&_a80m = mave(cpsrev'ts&sex&_a80,2)*diff(cpsrev'id(lout'lfpname+local'ex)&sex&_a80)
      -local'dca_lfpr&sex&_a80m = mave(cpsrev'ts&sex&_a80,2)*diff(cpsrev'id(lout'lfpname+local'ex)&sex&_a80)
   end loop

   series <over on> work'vind,work'vdesc,work'vname:string indexed by case
   set vind[1] = "0"; set vdesc[1] = "Cohort Effects"; set vname[1] = "Cumulative contribution to change"
   -/vcount = 1
   if exists(lout'temm)
      set vind[2] = "100"; set vdesc[2] = "Time Effects"; set vname[2] = "Cumulative contribution to change"
      set work'vcount = 2
   end if

   if exists(lout'vars)
      loop for II=1 to lastvalue(lout'vars)
         set vcount = vcount+1
         set vind[vcount] = string(II); set vdesc[vcount] = lout'vardesc[II]; set vname[vcount] = lout'vars[II]
         if lout'varlagged[II] eq 1
            loop for LL=1 to lastvalue(lout'v&II&_lags)
               set vcount = vcount+1
               set vind[vcount] = string(II)+"l"+string(lout'v&II&_lags[LL])
               set vdesc[vcount] = lout'vardesc[II]+" ("+string(lout'v&II&_lags[LL])+"-Period Lag)"
               set vname[vcount] = lout'vars[II]+"L"+string(lout'v&II&_lags[LL])
            end loop
         end if
      end loop
   end if
   
   loop for vv=1 to vcount
      -/vm_list = wildlist(local,"cc_v"+vind[vv]+"_a^^_gm")
      -/vf_list = wildlist(local,"cc_v"+vind[vv]+"_a^^_gf")
      if length(vm_list) gt 0
         if length(vf_list) gt 0
            -/v&id(vind[vv])&_gm = 100*csum(lsum(vm_list)) 
            -/v&id(vind[vv])&_gf = 100*csum(lsum(vf_list))
            -/v&id(vind[vv]) = v&id(vind[vv])&_gm+v&id(vind[vv])&_gf
         else
            -/v&id(vind[vv])&_gm = 100*csum(lsum(vm_list))
            -/v&id(vind[vv]) = v&id(vind[vv])&_gm
         end if
      else if length(vf_list) gt 0
         -/v&id(vind[vv])&_gf = 100*csum(lsum(vf_list))
         -/v&id(vind[vv]) = v&id(vind[vv])&_gf
      end if

      loop for i=1 to lastvalue(local'agelower)
         -local'grpvar = string(local'agelower[i])+(if local'ageupper[i] eq 80 then "p" else ("t"+string(local'ageupper[i])))
         <case agelower[i] to ageupper[i]> -/agelist = nl(string(n))

         -/vm_list2 = selectnames(vm_list,length({id(left(right(name(@name),5),2))} intersect agelist) gt 0)
         -/vf_list2 = selectnames(vf_list,length({id(left(right(name(@name),5),2))} intersect agelist) gt 0)

         if length(vm_list2) gt 0
            if length(vf_list2) gt 0
               -/v&id(vind[vv])&_a&id(grpvar)&_gm = 100*csum(lsum(vm_list2))
               -/v&id(vind[vv])&_a&id(grpvar)&_gf = 100*csum(lsum(vf_list2))
               -/v&id(vind[vv])&_a&id(grpvar) = v&id(vind[vv])&_a&id(grpvar)&_gm+v&id(vind[vv])&_a&id(grpvar)&_gf
            else
               -/v&id(vind[vv])&_a&id(grpvar)&_gm = 100*csum(lsum(vm_list2))
               -/v&id(vind[vv])&_a&id(grpvar) = v&id(vind[vv])&_a&id(grpvar)&_gm
            end if
         else if length(vf_list2) gt 0
            -/v&id(vind[vv])&_a&id(grpvar)&_gf = 100*csum(lsum(vf_list2))
            -/v&id(vind[vv])&_a&id(grpvar) = v&id(vind[vv])&_a&id(grpvar)&_gf
         end if

         -/agm_pop = lsum(crosslist({popm_a},agelist))
         -/agf_pop = lsum(crosslist({popf_a},agelist))
         -/ag_pop = agm_pop + agf_pop


         loop for GG in {m,f}
            loop for AA=agelower[i] to ageupper[i]
               if exists(dc_v&id(vind[vv])&_a&AA&_g&GG)
                  -local'aag_v&id(vind[vv])&_a&AA&_ag&id(grpvar)&_g&GG = mave(cpsrev'pop&GG&_a&AA/ag&GG&_pop,2)*dc_v&id(vind[vv])&_a&AA&_g&GG
                  -local'aa_v&id(vind[vv])&_a&AA&_ag&id(grpvar)&_g&GG = mave(cpsrev'pop&GG&_a&AA/ag_pop,2)*dc_v&id(vind[vv])&_a&AA&_g&GG
               end if
            end loop
         end loop

         -/aagm_list = wildlist(local,"aag_v"+vind[vv]+"_a^^_ag"+grpvar+"_gm")
         -/aagf_list = wildlist(local,"aag_v"+vind[vv]+"_a^^_ag"+grpvar+"_gf")
         -/aam_list = wildlist(local,"aa_v"+vind[vv]+"_a^^_ag"+grpvar+"_gm")
         -/aaf_list = wildlist(local,"aa_v"+vind[vv]+"_a^^_ag"+grpvar+"_gf")

         -gotone = false
         if length(vm_list2) gt 0
            set gotone = true
            if length(vf_list2) gt 0
               -/aag_v&id(vind[vv])&_gm_&id(grpvar) = 100*csum(lsum(aagm_list)) 
               -/aag_v&id(vind[vv])&_gf_&id(grpvar) = 100*csum(lsum(aagf_list))

               -/aa_v&id(vind[vv])&_gm_&id(grpvar) = 100*csum(lsum(aam_list)) 
               -/aa_v&id(vind[vv])&_gf_&id(grpvar) = 100*csum(lsum(aaf_list))
               -/aa_v&id(vind[vv])&_&id(grpvar) = aa_v&id(vind[vv])&_gm_&id(grpvar) + aa_v&id(vind[vv])&_gf_&id(grpvar)
            else
               -/aag_v&id(vind[vv])&_gm_&id(grpvar) = 100*csum(lsum(aagm_list)) 

               -/aa_v&id(vind[vv])&_gm_&id(grpvar) = 100*csum(lsum(aam_list)) 
               -/aa_v&id(vind[vv])&_&id(grpvar) = aa_v&id(vind[vv])&_gm_&id(grpvar)
            end if
         else if length(vf_list2) gt 0
            set gotone=true
            -/aag_v&id(vind[vv])&_gf_&id(grpvar) = 100*csum(lsum(aagf_list))

            -/aa_v&id(vind[vv])&_gf_&id(grpvar) = 100*csum(lsum(aaf_list))
            -/aa_v&id(vind[vv])&_&id(grpvar) = aa_v&id(vind[vv])&_gf_&id(grpvar)

         end if

         if gotone
            -/nl = wildlist(work,"aag_v"+vind[vv]+"_g^_"+grpvar)+wildlist(work,"aa_v"+vind[vv]+"_g^_"+grpvar)+wildlist(work,"aa_v"+vind[vv]+"_"+grpvar)+wildlist(work,"v"+vind[vv]+"_a"+grpvar+"?")

            type NEWLINE+"GROUP: "+grpvar+NEWLINE+vdesc[vv]+" ("+vname[vv]+" -- var number "+string(vind[vv])+")"
            type "VARIABLE NAME KEY"
            type "    AAG_ => contrib to Gender Group, AA_=> contrib to Group, neither AA_ nor AAG_ => contrib to total"
            type "     _GM => Male, _GF => Female, neither => both genders"+NEWLINE
            type "date"+sum(","+sl(nl))
            loop for dd = make(date(monthly),"1976M2") to make(date(monthly),"2016m12")
               freq m; date dd
               type string(dd)+sum(","+numfmt(slice(nl),auto,10))
            end loop
            date *
         end if

      end loop
   end loop

   -- PRODUCE SOME PLOTS 
   channel warning none
   thickness medium 3
   thickness thick 10

   legend contents description off 
   legend size small

   map color postscript C1  "black", c2  "blue", C3 "red", C4 "green", c5 "darkmagenta", &&
                        C6 "#707070", C7 "gold", C8 "seagreen", C9 "hotpink", c10 "darkturquoise", &&
                        C11 "burlywood", C12 "brown", C13 "tomato", c14 "lightsteelblue", c15 "#d9d9d9", &&
                        c16 "Lemonchiffon"

   plot color #1 c1, #2 c2, #3 c3, #4 c4, #5 c5, &&
              #6 c6, #7 c7, #8 c8, #9 c9, #10 c10, &&
              #11 c11, #12 c12, #13 c13, #14 c14
   plot style solid

   device graphics postp
   legend size small, fill horizontal
   legend division rows auto, column 5
   legend color black
   thickness thick 15
   page title area length standard
   page title #1 right size xsmall, text datefmt(lout'runtime), color c1, font f10
   page division rows 2, columns 1


   open <ac over; kind graphic> file("cbrooks2est_run"+string(runno)+".ps") as pcontout
   channel graphics pcontout

   page division rows 2, columns 1
   loop for vv=1 to vcount
      graph
         title #1 size small, text vname[vv]+": "+vdesc[vv]
         if exists(v&id(vind[vv])&_gm)
            if exists(v&id(vind[vv])&_gf)
               data v&id(vind[vv]) <plot name "Total",color c1, thickness xthin>, &&
                    v&id(vind[vv])&_gm <plot name "Men",color c2, thickness xthin>, &&
                    v&id(vind[vv])&_gf <plot name "Women",color c3, thickness xthin>
            else
               data v&id(vind[vv]) <plot name "Men = Total",color c1, thickness xthin>
            end if
         else
            data v&id(vind[vv]) <plot name "Women = Total",color c1, thickness xthin>
         end if
      end graph
      if vv eq 1 and not exists(lout'temm); refresh; end if
   end loop

   close pcontout
   execute "!(ps2pdf cbrooks2est_run"+string(runno)+".ps cbrooks2est_run"+string(runno)+".pdf; "+&&
             "gv cbrooks2est_run"+string(runno)+".ps; "+&&
             "rm -f cbrooks2est_run"+string(runno)+".ps)&"

   open <ac over; kind graphic> file("cbrooks3est_run"+string(runno)+".ps") as pcontout
   channel graphics pcontout

   tick label size xsmall, font f10
   legend size xsmall
   page division rows 4, columns 2
   loop for age=16 to 79
      loop for vv=1 to vcount
         title #1 size small, text "Age "+string(age)+": "+vname[vv]+": "+vdesc[vv]
         if exists(dc_v&id(vind[vv])&_a&age&_gm)
            graph
               if exists(dc_v&id(vind[vv])&_a&age&_gf)
                  data 100*csum(dc_v&id(vind[vv])&_a&age&_gm) <plot name "Men",color c2, thickness xthin>, &&
                       100*csum(dc_v&id(vind[vv])&_a&age&_gf) <plot name "Women",color c3, thickness xthin>
               else
                  data 100*csum(dc_v&id(vind[vv])&_a&age&_gm) <plot name "Men",color c1, thickness xthin>
               end if
            end graph
         else if exists(dc_v&id(vind[vv])&_a&age&_gf)
            graph
               data 100*csum(dc_v&id(vind[vv])&_a&age&_gf) <plot name "Women",color c1, thickness xthin>
            end graph
         end if
      end loop
      refresh
   end loop

   close pcontout
   execute "!(ps2pdf cbrooks3est_run"+string(runno)+".ps cbrooks3est_run"+string(runno)+".pdf; "+&&
             "gv cbrooks3est_run"+string(runno)+".ps; "+&&
             "rm -f cbrooks3est_run"+string(runno)+".ps)&"

   close all

end block
end procedure
